////////////////////////////////////////////////////////////////////
//                                                                //
//  Klasse Game                                                   //
//                                                                //
//  Funktion: Bereitstellung von einer Methode zur Belegung eines //
//     Feldes mit toten und lebenden Zellen sowie Methoden zur    //
//     Berechnung der neuen Generation                            //
//                                                                //
//  Instanzvariablen:                                             //
//     feld[][][]/ boolesches Feld mit lebenden und toten Zellen, //
//                 die dritte Dimension wird fr die Berechnung   //
//                 neuer Generationen bentigt                    //
//     -> Belegung des Feldes: false = tote Zelle                 //
//                             true = lebende Zelle               //
//                                                                //
//     n,m / Laenge und Breite des Feldes                         //
//     anzahl/ Anzahl der mit zufall() zufllig belebten Zellen   //
//     generation/ Zhler fr die Generation                      //
//                                                                //
//  Verwendet von: class GameFenster                              //
//                                                                //
//  Verwendete Klassen: keine                                     //
//                                                                //
//  Autor:  Nina Schumer          Datum:  04.09.2001              //
//                                                                //
////////////////////////////////////////////////////////////////////


import java.applet.Applet;
import java.awt.*;
import java.util.*; // fr die Zufallszahlen


public class Game{


   /* ----- Instanzvariablen ----- */

   boolean feld[][][];   // erstelle eine Matrix, dritte Dimension wird
			// zur Berechnung der nchsten Generation
			// bentigt
   int n,m,anzahl; 	// Laenge und Breite der Matrix sowie Anzahl
			// der per Zufall erstellten lebenden Zellen
   int generation=1;    // Zhler fr die Generation

   /* ----- Konstruktor ----- */

   public Game(int n, int m, int anzahl) 
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Konstruktor, erstellt eine neue Game-Population (tot)
   //
   //  Parameter: n, m / Laenge und Breite des Feldes
   //             anzahl / Anzahl der per Zufall erstellten lebenden Zellen
   //
   //  Aufgerufen von: Konstruktor in class GameFenster
   //
   //  Verwendung folgender globaler Variablen: feld[][][], n, m, anzahl
   //
   //  Benutzte Methoden: initializeMatrix(), initializeGeneration()
   //
   ///////////////////////////////////////////////////////////////////
   {

      this.n = n;
      this.m = m;
      this.anzahl=anzahl;
      feld = new boolean[n][m][2];
      initializeMatrix();
      initializeGeneration();
   }


   /* ----- Methoden ----- */

   public void initializeMatrix()
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Initialisiert die Populationsmatrix mit toten Zellen
   //
   //  Parameter: keine
   //
   //  Aufgerufen von: Game-Konstruktor
   //     in class GameFenster: actionPerformed(ActionEvent) bei Bettigung
   //                           des "Lschen"-Buttons
   //
   //  Verwendung folgender globaler Variablen: feld[][][], n, m
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      for (int i=0; i<n; i++){
         for (int j=0; j<m; j++) {
            feld[i][j][0]=false;
            feld[i][j][1]=false;
         }
      }
   }
 

   public void randomMatrix()
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Belebung von "anzahl" zufllig ausgewhlten Zellen
   //            in der Populationsmatrix
   //
   //  Parameter: keine
   //
   //  Aufgerufen von: 
   //     in class GameFenster: actionPerformed(ActionEvent) bei Bettigung
   //                           des "Zufall"-Buttons
   //
   //  Verwendung folgender globaler Variablen: feld[][][], n, m
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      int n1,m1;
      for (int i=0; i<anzahl; i++) {
         n1=(int)(Math.random() * n);
         m1=(int)(Math.random() * m);
         // pruefen, ob die Zelle wirklich noch nicht lebt, sonst Wiederholung:
         if (feld[n1][m1][0]==false) feld[n1][m1][0]=true; 
         else i--;
      }
   }


   public void nextGeneration()
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Berechnet die nchste Generation der Population nach
   //     den vorgegebenen Regeln
   //
   //  Parameter: keine
   //
   //  Aufgerufen von: 
   //     in class GameFenster: run() (wenn die Simulation luft)
   //
   //  Verwendung folgender globaler Variablen: feld[][][], n, m
   //
   //  Benutzte Methoden: countNeighbours(int, int), incGeneration()
   //
   ///////////////////////////////////////////////////////////////////
   {
      int nb; // Anzahl der ZellNachbarn

      // Ermittle die Matrix der nchsten Generation
      for (int i=0; i<n; i++)
      {
         for (int j=0; j<m; j++)
         {
            nb=countNeighbours(i,j);

            // Eine lebende Zelle lebt auch in der nchsten Generation, wenn zwei
            // oder drei ihrer acht Nachbarn in der aktuellen Generation leben. 
  
            if ((feld[i][j][0]==true) && ((nb==2) || (nb==3))) feld[i][j][1]=true;
  
 
            // Eine lebende Zelle stirbt an berbevlkerung, wenn mehr als drei
            // ihrer acht Nachbarn in der aktuellen Generation leben. 
            // Eine lebende Zelle stirbt an Vereinsamung, falls weniger als zwei
            // ihrer acht Nachbarn in der aktuellen Generation leben. 

            if ((feld[i][j][0]==true) && ((nb>3) || (nb<2))) feld[i][j][1]=false;


            // Eine tote Zelle wird in der nchsten Generation lebendig, wenn
            // genau drei ihrer acht Nachbarn in der aktuellen Generation leben.

            if ((feld[i][j][0]==false) && (nb==3)) feld[i][j][1]=true;
         }
      }

      // Kopiere die nchste Generation in die aktuelle Generation
      for (int i=0; i<n; i++){
         for (int j=0; j<m; j++){
            feld[i][j][0]=feld[i][j][1];
         }
      }
      incGeneration();
   } // end nextGeneration


   public boolean isSet(int x, int y)
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Liefert true zurck, wenn die angegebene Zelle
   //            lebt, andernfalls (oder falls die Koordinaten
   //            auerhalb der Arraygrenzen liegen) false 
   //
   //  Parameter: x, y / Koordinaten der Zelle, welche nach Lebendigkeit
   //                     geprft wird
   //
   //  Aufgerufen von: 
   //     in class GameFenster: mousePressed(MouseEvent) bei MouseClick
   //     auf die grafische Darstellung des Feldes, um eine Zelle zu
   //     beleben bzw zu tten
   //
   //  Verwendung folgender globaler Variablen: feld[][][]
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      try
      {
         return feld[x][y][0];
      }
      catch (Exception e)
      {
         return false;
      }
   }


   public boolean setXY(int x, int y) 
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Belebt eine Zelle
   //
   //  Parameter: x, y / Koordinaten der Zelle, welche belebt wird
   //
   //  Aufgerufen von: 
   //     in class GameFenster: mousePressed(MouseEvent), mouseDragged(MouseEvent)
   //     bei MouseClick und Ziehen auf der grafischen Darstellung 
   //     des Feldes, um Zellen zu beleben
   //    
   //  Verwendung folgender globaler Variablen: feld[][][]
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      try {
         feld[x][y][0]=true;
      }
      catch (ArrayIndexOutOfBoundsException e) 
      {
         return false;
      }
      return true;
   }


   public boolean deleteXY(int x, int y)
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Ttet eine Zelle
   //
   //  Parameter: x, y / Koordinaten der Zelle, welche gettet wird
   //
   //  Aufgerufen von: 
   //     in class GameFenster: mousePressed(MouseEvent), mouseDragged(MouseEvent)
   //     bei MouseClick und Ziehen auf der grafischen Darstellung 
   //     des Feldes, um Zellen zu tten
   //    
   //  Verwendung folgender globaler Variablen: feld[][][]
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      try
      {
         feld[x][y][0]=false;
      }
      catch (ArrayIndexOutOfBoundsException e)
      {
         return false;
      }
      return true;
   }


   private int countNeighbours(int x, int y)
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Zhlt die NachbarZellen einer Zelle 
   //
   //  Parameter: x, y / Koordinaten dieser Zelle
   //
   //  Aufgerufen von: nextGeneration()
   //    
   //  Verwendung folgender globaler Variablen: feld[][][]
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      int zahl=0; 
      for (int i=-1; i<=1; i++) {
         if ((x+i<n) && (x+i>=0)){
             if ((y-1>=0) && (feld[x+i][y-1][0]==true)) zahl++;
             if ((y+1<m) && (feld[x+i][y+1][0]==true)) zahl++;
	     if ((i!=0) && (feld[x+i][y][0]==true)) zahl++;
          }
      }

      return zahl;
   }

 
   public void initializeGeneration()
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Initialisiert generation mit 1
   //
   //  Parameter: keine
   //
   //  Aufgerufen von: Game-Konstruktor
   //     in class GameFenster: actionPerformed(ActionEvent
   //     Bettigung des "Zufall" - oder "Lschen" - Buttons
   //
   //  Verwendung folgender globaler Variablen: generation
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      generation=1;
   }


   private void incGeneration()
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Inkrementiert generation um 1
   //
   //  Parameter: keine
   //
   //  Aufgerufen von: nextGeneration()
   //
   //  Verwendung folgender globaler Variablen: generation
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      generation++;
   }


   public int getGeneration()
   ///////////////////////////////////////////////////////////////////
   //
   //  Funktion: Liefert den aktuellen Inhalt von generation zurck
   //
   //  Parameter: keine
   //
   //  Aufgerufen von: 
   //     in class GameFenster: actionPerformed(ActionEvent), run()
   //
   //  Verwendung folgender globaler Variablen: generation
   //
   //  Benutzte Methoden: keine
   //
   ///////////////////////////////////////////////////////////////////
   {
      return generation;
   }
}