UNIT u_itsort;
    { Einfache Sortierverfahren iterativ}

INTERFACE

CONST minimum=1;maximum=99;

TYPE tlist = ARRAY[minimum..maximum] OF INTEGER;

   tsort=class
     private
      anzahl:Byte; //Anzahl der Listenelemente
      unsortlist,sortlist:tlist; //zwei Listen, um die originale (unsortierte)
                                 //Liste zu erhalten
      PROCEDURE tausch(s1,s2:Integer);
      PROCEDURE sortiere;virtual;

     public
      CONSTRUCTOR create;
      PROCEDURE setunsortlist(VAR ul:tlist;anz:Byte);
      FUNCTION getunsortlist: tlist;
      FUNCTION  getsortlist:tlist;
   end;// class tsort

 tdiraustsort=class(tsort)
    private
     PROCEDURE sortiere;override;
    public
  end;// class tdiraustsort

 tdirauswsort=class(tsort)
    private
     PROCEDURE sortiere;override;
    public
  end;// class tdirauswsort

 tdireinfsort=class(tsort)
   private
     PROCEDURE sortiere;override;
   public
  end;// class tdireinfsort


IMPLEMENTATION

CONSTRUCTOR tsort.create;
VAR i:Integer;
BEGIN
 inherited create;
 FOR i:=minimum TO maximum DO BEGIN //erstmal die listen initialisieren
    unsortlist[i]:=0;
    sortlist[i]:=0;
 END;
END;//create

procedure tsort.sortiere;
begin
//zur Vererbung
end;

PROCEDURE tsort.tausch(s1,s2:Integer);
 VAR hilf : INTEGER;
 BEGIN
   hilf:=sortlist[s1];
   sortlist[s1]:=sortlist[s2];
   sortlist[s2]:=hilf
 END; { tausch }

PROCEDURE tsort.setunsortlist(VAR ul:tlist;anz:Byte);
BEGIN
 self.anzahl:=anz;
 self.unsortlist:=ul;
 self.sortlist:=ul
END;

FUNCTION tsort.getunsortlist: tlist;
BEGIN
  result:=self.unsortlist;
END;


FUNCTION tsort.getsortlist:tlist;
BEGIN
  self.sortiere;
  result:=self.sortlist;
END;

//-----------------------------------------------------------------------------
PROCEDURE tdiraustsort.sortiere;
 VAR i,ende: BYTE;
 BEGIN
   ende:=anzahl;
   REPEAT
     FOR i:=minimum TO ende-1 DO
          IF sortlist[i] > sortlist[i+1] THEN
                             self.tausch(i,i+1);
     ende:=ende-1;
   UNTIL ende=1
 END; { direkter_austausch }

//-----------------------------------------------------------------------------
PROCEDURE tdirauswsort.sortiere;
VAR i,anfang,ende,merke : INTEGER;
BEGIN
  anfang:=minimum;
  ende:=anzahl;
  REPEAT
    merke:=anfang;
    FOR i:=anfang+1 TO ende DO
      IF sortlist[i] < sortlist[merke] THEN merke:=i;
    tausch(anfang,merke);
    anfang:=anfang+1;
  UNTIL anfang = ende
END; { direkte_auswahl }

//-----------------------------------------------------------------------------
PROCEDURE tdireinfsort.sortiere;
 VAR anfang,ende,i,j,merke : INTEGER;
  BEGIN
    anfang:=minimum;
    ende:=anzahl;
    FOR i:=anfang+1 TO ende DO
      BEGIN
        j:=i-1;merke:=sortlist[i];
        WHILE (merke < sortlist[j]) AND (j>=1) DO
          BEGIN
            sortlist[j+1]:=sortlist[j];
            j:=j-1
          END;  { while .. do }
        sortlist[j+1]:=merke;
      END { for .. to .. do }
END; { direkt_einfuegen }


END.{u_itsort}
