UNIT ukrypto;

INTERFACE
 USES sysutils;

 TYPE t_text= String;
 tcodiermaschine=class(TObject)
 private
  klartext,codetext: t_text;
  CONSTRUCTOR create;
 public
  PROCEDURE setklartext(text: t_text);
  PROCEDURE verschluesseln(c: String);virtual;
  FUNCTION getcodetext: t_text;
 end;


 tcaesar=class(tcodiermaschine)
 private
   codezahl:Byte;
   PROCEDURE caesar_code;
 public
   CONSTRUCTOR create;
   PROCEDURE verschluesseln(code: String);override;
 end;


 tvigenere=class(tcodiermaschine)
  private
   schluesseltext: t_text;
   PROCEDURE vigenere_code;
  public
   CONSTRUCTOR create;
   PROCEDURE verschluesseln(code: String);override;
  end;

IMPLEMENTATION
 CONSTRUCTOR tcodiermaschine.create;
  BEGIN
   inherited create;
   self.klartext:='';
   self.codetext:='';
  END;

 PROCEDURE tcodiermaschine.setklartext(text: t_text);
  BEGIN
   self.klartext:=text;
   self.codetext:=text;
  END;

 FUNCTION tcodiermaschine.getcodetext:t_text;
  BEGIN
   result:=self.codetext
  END;

  PROCEDURE tcodiermaschine.verschluesseln;
  BEGIN
   //nur zur Vererbung
  END;

//-----------------Beginn caesar-----------------------------------
 CONSTRUCTOR tcaesar.create;
  BEGIN
    inherited create
  END;

 PROCEDURE tcaesar.caesar_code;
  VAR i,laenge,neu:Byte;
  BEGIN
    laenge:=length(klartext);
    FOR i:=1 TO laenge DO
     BEGIN
      IF ((ord(klartext[i])>=65) AND (ord(klartext[i])<=90)) OR
         ((ord(klartext[i])>=97) AND (ord(klartext[i])<=122))
      THEN BEGIN
       IF upcase(klartext[i])= klartext[i]
         THEN BEGIN
            neu:=ord(klartext[i]) + codezahl;
            IF neu>90 THEN neu:=neu-26;
            IF neu<65 THEN neu:=neu+26;
            codetext[i]:=chr(neu)
         END
         ELSE BEGIN
            neu:=ord(klartext[i]) + codezahl;
            IF neu>122 THEN neu:=neu-26;
            IF neu<97 THEN neu:=neu+26;
            codetext[i]:=chr(neu)
         END
       END
   END {for i to laenge}
  END;

  PROCEDURE tcaesar.verschluesseln(code: String);
  BEGIN
   self.codezahl:=StrToInt(code);
   self.caesar_code
  END;
//------------------------------Ende Caesar------------------------

//------------------------------Beginn Vigenere--------------------

Constructor tvigenere.create;
BEGIN
 inherited create
END;

PROCEDURE tvigenere.vigenere_code;
TYPE t_textfeld=ARRAY[1..50] OF WORD;
 VAR  i: BYTE;
      ktext,stext,chiffre: t_textfeld;
 BEGIN
   klartext:=Uppercase(klartext);
   FOR i:=1 TO length(klartext) DO
     BEGIN
        ktext[i]:=ord(klartext[i])-64;
        stext[i]:=ord(schluesseltext[i])-64;
        chiffre[i]:=(ktext[i]+stext[i]) MOD 26;
        codetext[i]:=chr(chiffre[i]+64);
     END;

 END;

PROCEDURE tvigenere.verschluesseln(code: String);
BEGIN
 self.schluesseltext:=code;
 self.vigenere_code
END;

END.
